;-| Button Remapping |-----------------------------------------------------
; This section lets you remap the player's buttons (to easily change the
; button configuration). The format is:
;   old_button = new_button
; If new_button is left blank, the button cannot be pressed.
[Remap]
x = x
y = y
z = z
a = a
b = b
c = c
s = s

;-| Default Values |-------------------------------------------------------
[Defaults]
; Default value for the "time" parameter of a Command. Minimum 1.
command.time = 15

; Default value for the "buffer.time" parameter of a Command. Minimum 1,
; maximum 30.
command.buffer.time = 1


;-| Super Motions |--------------------------------------------------------
;The following two have the same name, but different motion.
;Either one will be detected by a "command = TripleKFPalm" trigger.
;Time is set to 20 (instead of default of 15) to make the move
;easier to do.
;
;Ă
[Command]
name = "yaki"
command = ~D,F,D,F,a
time = 20

;SW
[Command]
name = "zen"
command = ~D,F,D,F,b
time = 20

;}XN
[Command]
name = "mas"
command = ~D,F,D,F,c
time = 20

;-| Special Motions |------------------------------------------------------
;LbN
[Command]
name = "keri"
command = ~D,D,a

;LbN
[Command]
name = "keri2"
command = ~D,D,b

;S
[Command]
name = "suto"
command = ~D,D,c

;~TC
[Command]
name = "miso"
command = ~D, B, b

;
[Command]
name = "skousen"
command = ~D, B, a

;
[Command]
name = "te"
command = ~D, F, a

;
[Command]
name = "te2"
command = ~D, F, b

;
[Command]
name = "te3"
command = ~D, F, c

[Command]
name = "wan"
command = ~D, B, c

;-| Double Tap |-----------------------------------------------------------
[Command]
name = "FF"     ;Required (do not remove)
command = F, F
time = 10

[Command]
name = "BB"     ;Required (do not remove)
command = B, B
time = 10

;-| 2/3 Button Combination |-----------------------------------------------
[Command]
name = "recovery";Required (do not remove)
command = x
time = 1

[Command]
name = "recovery";Required (do not remove)
command = a
time = 1

[Command]
name = "recovery";Required (do not remove)
command = b
time = 1

[Command]
name = "recovery";Required (do not remove)
command = c
time = 1

;-| Dir + Button |---------------------------------------------------------
[Command]
name = "down_a"
command = /$D,a
time = 1

[Command]
name = "down_b"
command = /$D,b
time = 1

;-| Single Button |---------------------------------------------------------
[Command]
name = "a"
command = a
time = 1

[Command]
name = "b"
command = b
time = 1

[Command]
name = "c"
command = c
time = 1

[Command]
name = "x"
command = x
time = 1

[Command]
name = "y"
command = y
time = 1

[Command]
name = "z"
command = z
time = 1

[Command]
name = "start"
command = s
time = 1

;-| Hold Dir |--------------------------------------------------------------
[Command]
name = "holdfwd";Required (do not remove)
command = /$F
time = 1

[Command]
name = "holdback";Required (do not remove)
command = /$B
time = 1

[Command]
name = "holdup" ;Required (do not remove)
command = /$U
time = 1

[Command]
name = "holddown";Required (do not remove)
command = /$D
time = 1

;---------------------------------------------------------------------------
; 2. State entry
; --------------
; This is where you define what commands bring you to what states.
;
; Each state entry block looks like:
;   [State -1, Label]           ;Change Label to any name you want to use to
;                               ;identify the state with.
;   type = ChangeState          ;Don't change this
;   value = new_state_number
;   trigger1 = command = command_name
;   . . .  (any additional triggers)
;
; - new_state_number is the number of the state to change to
; - command_name is the name of the command (from the section above)
; - Useful triggers to know:
;   - statetype
;       S, C or A : current state-type of player (stand, crouch, air)
;   - ctrl
;       0 or 1 : 1 if player has control. Unless "interrupting" another
;                move, you'll want ctrl = 1
;   - stateno
;       number of state player is in - useful for "move interrupts"
;   - movecontact
;       0 or 1 : 1 if player's last attack touched the opponent
;                useful for "move interrupts"
;
; Note: The order of state entry is important.
;   State entry with a certain command must come before another state
;   entry with a command that is the subset of the first.
;   For example, command "fwd_a" must be listed before "a", and
;   "fwd_ab" should come before both of the others.
;
; For reference on triggers, see CNS documentation.
;
; Just for your information (skip if you're not interested):
; This part is an extension of the CNS. "State -1" is a special state
; that is executed once every game-tick, regardless of what other state
; you are in.


; Don't remove the following line. It's required by the CMD standard.
[Statedef -1]
;---------------------------------------------------------------------------
;Ă
[State -1, Stand Light Kick]
type = ChangeState
value = 3000
triggerall = power >= 1000
triggerall = command = "yaki"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = (stateno = 200) && time > 7
trigger3 = (stateno = 230) && time > 9

;---------------------------------------------------------------------------
;}XN
[State -1, Stand Light Kick]
type = ChangeState
value = 2100
triggerall = power >= 3000
triggerall = command = "mas"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = (stateno = 200) && time > 7
trigger3 = (stateno = 230) && time > 9

;---------------------------------------------------------------------------
;S
[State -1, Stand Light Kick]
type = ChangeState
value = 1080
triggerall = power >= 1000
triggerall = command = "zen"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = (stateno = 200) && time > 7
trigger3 = (stateno = 230) && time > 9

;---------------------------------------------------------------------------
;уLbN
[State -1, Standing Strong Kick]
type = ChangeState
value = 1150
triggerall = command = "keri"
trigger1 = ctrl
trigger2 = (stateno = 200) && time > 1
trigger3 = (stateno = 230) && time > 1
trigger2 = movecontact
trigger3 = movecontact

;---------------------------------------------------------------------------
;уLbN
[State -1, Standing Strong Kick]
type = ChangeState
value = 1160
triggerall = command = "keri2"
trigger1 = ctrl
trigger2 = (stateno = 200) && time > 1
trigger3 = (stateno = 230) && time > 1
trigger2 = movecontact
trigger3 = movecontact

;---------------------------------------------------------------------------
;S
[State -1, Standing Strong Kick]
type = ChangeState
value = 1400
triggerall = NumHelper(1410) = 0
triggerall = command = "suto"
trigger1 = ctrl
trigger2 = (stateno = 200) && time > 1
trigger3 = (stateno = 230) && time > 1
trigger2 = movecontact
trigger3 = movecontact

;---------------------------------------------------------------------------
;
[State -1, Standing Strong Kick]
type = ChangeState
value = 1300
triggerall = command = "te"
triggerall = statetype = S
trigger1 = ctrl
trigger2 = (stateno = 200) && time > 1
trigger3 = (stateno = 230) && time > 1
trigger2 = movecontact
trigger3 = movecontact

;---------------------------------------------------------------------------
;2
[State -1, Standing Strong Kick]
type = ChangeState
value = 1310
triggerall = command = "te2"
triggerall = statetype = S
trigger1 = ctrl
trigger2 = (stateno = 200) && time > 1
trigger3 = (stateno = 230) && time > 1
trigger2 = movecontact
trigger3 = movecontact

;---------------------------------------------------------------------------
;3
[State -1, Standing Strong Kick]
type = ChangeState
value = 1320
triggerall = command = "te3"
triggerall = statetype = S
trigger1 = ctrl
trigger2 = (stateno = 200) && time > 1
trigger3 = (stateno = 230) && time > 1
trigger2 = movecontact
trigger3 = movecontact

;---------------------------------------------------------------------------
;
[State -1, Standing Strong Kick]
type = ChangeState
value = 1350
triggerall = NumHelper(1351) = 0
triggerall = command = "wan"
;triggerall = statetype = S
trigger1 = ctrl
trigger2 = (stateno = 200) && time > 1
trigger3 = (stateno = 230) && time > 1
trigger2 = movecontact
trigger3 = movecontact
trigger4 = movetype = H

;---------------------------------------------------------------------------
;e
[State -1, Standing Strong Kick]
type = ChangeState
value = 210
triggerall = command = "skousen"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = (stateno = 200) && time > 1
trigger3 = (stateno = 230) && time > 1
trigger2 = movecontact
trigger3 = movecontact

;---------------------------------------------------------------------------
;~TC
[State -1, Standing Strong Kick]
type = ChangeState
value = 1200
triggerall = NumHelper(1210) = 0
triggerall = NumHelper(1220) = 0
triggerall = command = "miso"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = (stateno = 200) && time > 1
trigger3 = (stateno = 230) && time > 1
trigger2 = movecontact
trigger3 = movecontact


;---------------------------------------------------------------------------
;;jQ
;[State -1, nimuge]
;type = null;ChangeState
;value = 1050
;triggerall = command = "kousen"
;trigger1 = statetype = S
;trigger1 = ctrl

;---------------------------------------------------------------------------
;jQ2
;[State -1, nimuge]
;type = null;ChangeState
;value = 1000
;triggerall = command = "kousen2"
;trigger1 = statetype = S
;trigger1 = ctrl

;===========================================================================
;---------------------------------------------------------------------------
;Run Fwd
;_bV
[State -1, Run Fwd]
type = ChangeState
value = 100
trigger1 = command = "FF"
trigger1 = statetype = S
trigger1 = ctrl

;---------------------------------------------------------------------------
;Run Back
;ރ_bV
[State -1, Run Back]
type = ChangeState
value = 105
trigger1 = command = "BB"
trigger1 = statetype = S
trigger1 = ctrl

;---------------------------------------------------------------------------
;Kung Fu Throw
;
[State -1, Kung Fu Throw]
type = ChangeState
value = 800
triggerall = command = "x"
trigger1 = statetype = S
trigger1 = ctrl
trigger1 = stateno != 100


;===========================================================================
;---------------------------------------------------------------------------
;U
[State -1, Stand Light Kick]
type = ChangeState
value = 200
triggerall = command = "a"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = (stateno = 200) && time > 7
trigger3 = (stateno = 230) && time > 9

;---------------------------------------------------------------------------
;U2
[State -1, Stand Light Kick]
type = ChangeState
value = 230
triggerall = command = "b"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = (stateno = 200) && time > 1
trigger2 = movecontact

;---------------------------------------------------------------------------
;
[State -1, Stand Light Kick]
type = ChangeState
value = 250
triggerall = command = "c"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = (stateno = 200) && time > 1
trigger2 = movecontact

;---------------------------------------------------------------------------
;Taunt
;
[State -1, Taunt]
type = ChangeState
value = 195
triggerall = command = "start"
trigger1 = statetype != A
trigger1 = ctrl

;---------------------------------------------------------------------------
;Crouching Light Punch
;Ⴊݎp`
[State -1, Crouching Light Punch]
type = ChangeState
value = 400
triggerall = command = "a"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl

;---------------------------------------------------------------------------
;Crouching Strong Punch
;Ⴊ݋p`
[State -1, Crouching Strong Punch]
type = ChangeState
value = 410
triggerall = command = "b"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl
trigger2 = (stateno = 400) || (stateno = 430)
trigger2 = (time > 9) || (movecontact && time > 5)

;---------------------------------------------------------------------------
;---------------------------------------------------------------------------
;Jump Light Punch
;󒆎p`
[State -1, Jump Light Punch]
type = ChangeState
value = 600
triggerall = command = "a"
trigger1 = statetype = A
trigger1 = ctrl
trigger2 = stateno = 600
trigger2 = statetime >= 7
trigger3 = stateno = 1350 ;Air blocking

;---------------------------------------------------------------------------
;Jump Strong Punch
[State -1, Jump Strong Punch]
type = ChangeState
value = 610
triggerall = command = "b"
trigger1 = statetype = A
trigger1 = ctrl
trigger2 = stateno = 600 || stateno = 630 ;jump_x or jump_a
trigger2 = movecontact
trigger3 = stateno = 1350 ;Air blocking

